#include <iostream>
#include <cstdlib>
#include <cmath>
#include <vector>
#include <map>
#include <set>
#include <queue>
#include <ctime>
#include <cassert>
#include <string>
#include <cstdlib>
#include <cstring>
#include <algorithm>
#include <memory.h>

#define pb push_back
#define mp make_pair
#define fr first
#define sc second

using namespace std;

const int N = 1000;
const int INF = 1e9;
const int inf = 1e9;


struct Graph {
	struct Edge {
		int from, to, flow, cap;
		Edge() {}
		Edge(int from, int to, int cap) : from(from), to(to), flow(0), cap(cap) {}
	};

	int n;
	vector<Edge> edges;
	vector<vector<int> > e;
	vector<int> d, c;

	Graph() {}
	Graph(int n) {
		this->n = n;
		e.resize(n);
	}

	void addEdge(int from, int to, int cap, int cap2) {
		e[from].push_back(edges.size());
		edges.push_back(Edge(from, to, cap));
		e[to].push_back(edges.size());
		edges.push_back(Edge(to, from, cap2));
	}

	bool bfs(int v) {
		c.assign(n, 0);
		d.assign(n, inf);
		d[v] = 0;
		queue<int> q;
		q.push(0);
		while (!q.empty()) {
			int v = q.front();
			q.pop();
			for (int i = 0; i < (int)e[v].size(); i++) {
				Edge cur = edges[e[v][i]];
				if (cur.flow < cur.cap && d[cur.to] > d[v] + 1) {
					d[cur.to] = d[v] + 1;
					q.push(cur.to);
				}
			}
		}
		return d[n - 1] != inf;
	}
	
	int dfs(int v, int flow) {
		if (v == n - 1) return flow;
		if (flow == 0) return 0;
		for (int &i = c[v]; i < (int)e[v].size(); i++) {
			Edge cur = edges[e[v][i]];
			if (d[cur.to] != d[v] + 1) continue;
			int pushed = dfs(cur.to, min(flow, cur.cap - cur.flow));
			if (pushed) {
				edges[e[v][i]].flow += pushed;
				edges[e[v][i] ^ 1].flow -= pushed;
				return pushed;
			}
		}
		return 0;
	}

	int getFlow() {
		int flow = 0;
		while (bfs(0)) {
			while (int pushed = dfs(0, inf)) {
				flow += pushed;
			}
		}
		return flow;
	}
};


int c[N];

int main() {
#ifdef DEBUG
	freopen("in", "r", stdin);
#endif
	int n, m, k;
	scanf("%d%d%d", &n, &m, &k);
	for (int i = 0; i < n; i++) 
		scanf("%d", &c[i]);
	for (int i = 0; i < n; i++)  {
		int x;
		scanf("%d", &x);
	}
	Graph g(n + 2);
	for (int i = 0; i < m; i++) {
		int v, u;
		scanf("%d%d", &v, &u); 
		g.addEdge(v, u, INF, 0);
	}
	for (int i = 0; i < n; i++)
		if (c[i] >= 0) {
			g.addEdge(0, i + 1, c[i], 0);
		}
		else
			g.addEdge(i + 1, n + 1, -c[i], 0);
	
	int sum = 0;
	for (int i = 0; i < n; i++)
		sum += (c[i] > 0)? c[i]: 0;
	int f = g.getFlow();
	printf("%d\n", sum - f);
	vector < int > answer;
	for (int i = 1; i <= n; i++) {
		if (c[i - 1] >= 0) {
			for (auto u: g.e[i])
				if (g.edges[u].to == 0) {
					//cerr << "cmp1: " << g.edges[u ^ 1].flow << " " << g.edges[u ^ 1].cap << endl;
					if (g.edges[u ^ 1].flow != g.edges[u ^ 1].cap)
						answer.pb(i);
				}
		}
		else {
			for (auto u: g.e[i]) 
				if (g.edges[u].to == n + 1 && g.edges[u].flow == g.edges[u].cap)
					answer.pb(i);
		}
	}
	printf("%d\n", (int)answer.size());
	for (int i = 0; i < (int)answer.size(); i++)
		printf("%d ", answer[i]);			
	printf("\n");
	return 0;
}


